//
//  InspectorViewNodesController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import "GSInspectorViewController.h"
#import "GSTransformGrid.h"
#import <Cocoa/Cocoa.h>

@class GSNode;
@class GSTransformGrid;

@interface InspectorViewNodesController : GSInspectorViewController <GSTransformGridDataSource>

@property (nonatomic) NSInteger selectedCorner;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *heightField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *widthField;
@property (nonatomic, unsafe_unretained) IBOutlet GSTransformGrid *transformGrid;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *selectedNodeCountField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *allNodeCountField;

- (IBAction)setXorigin:(id)sender;
- (IBAction)setYorigin:(id)sender;
- (IBAction)setHeight:(id)sender;
- (IBAction)setWidth:(id)sender;

@end
